/***************************************************************/
//
//
//		DirectX	[ particle.h ]
//
//											Author	kazuki tanaka
//											Date	2016 11/28
/*---------------------------------------------------------------
Update : 2016/11/28
			particle.h̍쐬
			PARTICLȄ̒ǉ
			PARTICLȄI̒ǉ
			PARTICLE̍XV̒ǉ
			PARTICLE̕`揈̒ǉ

Update : 2016/11/28



/*-------------------------------------------------------------*/
#ifndef _PARTICLE_H_

#define _PARTICLE_H_

/*---------------------------------------------------------------
	\̒`
---------------------------------------------------------------*/

typedef enum{

	MOVEMENT_STRAIGHT = 0,
	MOVEMENT_CIRCLE,
	MOVEMENT_

}PARTICLE_MOVEMENT;

typedef struct{

	D3DXVECTOR3  scale;						// qXP[
	D3DXVECTOR3  rotation;					// q]xNg
	
	D3DXVECTOR3  center;					// qSW
	D3DXVECTOR3  speed;						// qx
	D3DXVECTOR3  ambientPower;				// qɊ|͂ɂ镗̉e
	D3DXVECTOR3  velocity;					// qx
	D3DXCOLOR    color;						// qF
	D3DXCOLOR    amountOfChangeInColor;		// qF̕ω
	float        radius;					// qa
	float        amountOfChangeInRadius;	// qa̕ω
	float        theta;						// qxyʕopx
	float        phy;						// qxzʕopx
	float        radiusValue;				// q̔aω
	int          life;						// q̎
	int          age;						// q݂̑t[

	int          texIndex;					// gpeNX`̃CfbNXԍ

	D3DXVECTOR3  gravity;					// qɊ|d
	static D3DXVECTOR3 GRAVITY;				// qŜɊ|d
	static D3DXVECTOR3 AMBIENT;				// qŜɊ|
	static D3DXVECTOR3 ROTATION;			// qŜ擾]l

	static int   PARTICLE_MAX;				// qő吔
	static int   LOAD_TEXTURE;				// qeNX`̃[h

}PARTICLE;

/*---------------------------------------------------------------
	Tu[`
---------------------------------------------------------------*/

void InitParticle( void );					// PARTICLȄ
void UninitParticle( void );				// PARTICLȄI
void UpdateParticle( void );				// PARTICLE̍XV
void DrawParticle( void );					// PARTICLE̕`揈

char** GetTextureParticle( void );
char*  GetTextureParticleTestAlpha( void );

void SetAddCalcRender( const bool flag );
void SetSubCalcRender( const bool flag );
void SetRotationFlag( const bool flag );
void SetLightingRender( const bool flag );
void TextureLoad( const LPTSTR TEXTURE_FILE_NAME );

PARTICLE* GetParticleStatus( void );		// PARTICLẼAhX擾
	 
void SetParticle( 
	const LPD3DXVECTOR3 center,
	const LPD3DXVECTOR3 velocity,
	const LPD3DXCOLOR color,
	const float radius,
	const unsigned int life );

void SetParticleEx( 
	const LPD3DXVECTOR3 center,
	const LPD3DXVECTOR3 speed,
	const LPD3DXVECTOR3 velocity,
	const LPD3DXCOLOR color,
	const float radius,
	const int theta,
	const int theta_offset,
	const int phy,
	const int phy_offset,
	const unsigned int life,
	const int texIndex );


#endif	//	_PARTICLE_H_


